<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class SysxUser extends Authenticatable implements JWTSubject
{
    //
    use Notifiable;
    protected $table = 'sysx_user';
    protected $primaryKey = 'user_id';
    protected $fillable = [
        'username', 'password_hash'
    ];
    protected $hidden = ['sysx_key', 'auth_key', 'password_hash', 'password_reset_token'];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    public function getJWTCustomClaims()
    {
        return [];
    }
    public function dimxdim()
    {
        return $this->hasOne('App\DimxDim');
    }
}
